


    def __init__(self, options, log, progress_reporter):
            BasicNewsRecipe.__init__(self, options, log, progress_reporter)
            self.navbar = KindleNavBarTemplate() # use Kindle template instead

    def create_opf(self, feeds, dir=None):
            BasicNewsRecipe.create_opf(self, feeds, dir)
            # modify the opf and ncx files
            fname = os.getenv('CALIBRE_RECIPE_NAME')
            if dir is None:
                    dir = self.output_dir
            opf_path = os.path.join(dir, 'index.opf')
            ncx_path = os.path.join(dir, 'index.ncx')
            ncx_stream = open(ncx_path)
            opf_stream = open(opf_path)
            ncx_raw = ncx_stream.read()
            ncx_raw = re.sub(r'</navPoint>\s*</navPoint>\s*<navPoint','</navPoint></navPoint><navPoint class="section"',ncx_raw)
            ncx_raw = ncx_raw.replace('navPoint','navPoint class="section"',1)
            ncx_raw = ncx_raw.replace('navPoint id','navPoint class="article" id')
            ncx_raw = ncx_raw.replace('<navMap>','<navMap><navPoint class="periodical" id="Periodical" playOrder="1"><mbp:meta-img src="mastheadImage.jpg" name="mastheadImage"/><navLabel><text>Periodical</text></navLabel><content src="index.html"/>',1)
            ncx_raw = ncx_raw.replace('</navMap>','</navPoint></navMap>',1)
            ncx_raw = ncx_raw.replace('calibre:meta','mbp:meta')            
            directory = os.path.expanduser('~')+'\\Calibre-Kindle\\Recipes\\Temp'
            alt_ncx_path = os.path.join(directory,fname+'.ncx')
            alt_ncx_stream = open(alt_ncx_path,'wb')
            alt_ncx_stream.write(ncx_raw);
            alt_ncx_stream.flush()
            alt_ncx_stream.close()
            opf_raw = opf_stream.read()
            opf_raw = opf_raw.replace('</metadata>','<x-metadata><output encoding="utf-8" content-type="application/x-mobipocket-subscription-magazine"></output></x-metadata></metadata>',1)
            opf_raw = opf_raw.replace('href="index.ncx" id="ncx"','href="'+fname+'.ncx" id="ncx"',1)
            fix_title = os.getenv('MODIFY_TITLE')
            if fix_title=='yes':
                    opf_raw = opf_raw.replace('</dc:title>',' *</dc:title>')
            alt_opf_path = os.path.join(directory,fname+'.opf')
            alt_opf_stream = open(alt_opf_path,'wb')
            alt_opf_stream.write(opf_raw);
            alt_opf_stream.flush()
            alt_opf_stream.close()

    def feed2index(self, f, feeds):
        feed = feeds[f]
        if feed.image_url is not None: # Download feed image
            imgdir = os.path.join(self.output_dir, 'images')
            if not os.path.isdir(imgdir):
                os.makedirs(imgdir)

            if self.image_map.has_key(feed.image_url):
                feed.image_url = self.image_map[feed.image_url]
            else:
                bn = urlparse.urlsplit(feed.image_url).path
                if bn:
                    bn = bn.rpartition('/')[-1]
                    if bn:
                        img = os.path.join(imgdir, 'feed_image_%d%s'%(self.image_counter, os.path.splitext(bn)))
                        try:
                            with nested(open(img, 'wb'), closing(self.browser.open(feed.image_url))) as (fi, r):
                                fi.write(r.read())
                            self.image_counter += 1
                            feed.image_url = img
                            self.image_map[feed.image_url] = img
                        except:
                            pass
            if isinstance(feed.image_url, str):
                feed.image_url = feed.image_url.decode(sys.getfilesystemencoding(), 'strict')


        templ = KindleFeedTemplate() # use Kindle template instead
        css = self.template_css + '\n\n' +(self.extra_css if self.extra_css else '')

        if self.touchscreen:
            templ = templates.TouchscreenFeedTemplate()

        return templ.generate(f, feeds, self.description_limiter,
                              extra_css=css).render(doctype='xhtml')




